/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.flatpack;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.Map;
import net.sf.flatpack.DataSet;
import org.apache.camel.component.flatpack.FlatpackConverter;

public class DataSetList
extends AbstractList<Map<String, Object>> {
    private final DataSet dataSet;

    public DataSetList(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    @Override
    public Map<String, Object> get(int index) {
        this.dataSet.absolute(index);
        return FlatpackConverter.toMap(this.dataSet);
    }

    @Override
    public int size() {
        return this.dataSet.getRowCount();
    }

    @Override
    public Iterator<Map<String, Object>> iterator() {
        this.dataSet.goTop();
        return new Iterator<Map<String, Object>>(){
            private boolean hasNext;
            {
                this.hasNext = DataSetList.this.dataSet.next();
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public Map<String, Object> next() {
                Map<String, Object> result = FlatpackConverter.toMap(DataSetList.this.dataSet);
                this.hasNext = DataSetList.this.dataSet.next();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove() not supported");
            }
        };
    }
}

